#' Sample mortality data stratified by gender/sex in the UK
#'
#' This is a sample data set used for demonstration purposes. They consist of two 3-dimensional arrays, one for number of deaths (\code{dxt_array_sex}) and another for the the corresponding central exposures to risk (\code{Ext_array_sex}).
#'
#' @docType data
#' @usage data("dxt_array_sex")
#' @format A 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years) with 2 strata (males and females), 111 ages, and 181 years:
#' \describe{
#'   \item{Strata}{Character. Indicate the gender/sex, labelled as: \cr 
#'   \code{"Male"}: ; \cr 
#'   \code{"Female"}: ..}
#'   \item{Ages}{Numeric. Ages at deaths, ranging between 0-109, and 110+.}
#'   \item{Years}{Numeric. Years at deaths, spanning years 1841-2021.}
#' }
#' @keywords datasets
#' @rdname data_array_sex
#' @examples
#' ##Load death data
#' data("dxt_array_sex")
#' str(dxt_array_sex)
#' head(dxt_array_sex)
#' 
#' #extracting a subset of the data (2 genders, ages 0-100, years 1961-2000)
#' dxt_array_sex[c("Male","Female"),as.character(0:100),as.character(1961:2000)]
#' 
"dxt_array_sex"