% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_MCMC.R
\name{Run_MCMC}
\alias{Run_MCMC}
\title{Run MCMC Analysis with Specified Option File}
\usage{
Run_MCMC(option_file, excel_file = NULL, output_path = NULL)
}
\arguments{
\item{option_file}{The name of the option file (e.g., "option1.R") located in the current working directory.}

\item{excel_file}{The path to the Excel file containing the data.}

\item{output_path}{Directory where the output will be saved. If `NULL`, uses a temporary directory.}
}
\value{
None. The function executes and saves results directly.
}
\description{
This function runs an MCMC analysis based on the specified option file, sourcing auxiliary scripts, and executing the analysis.
}
\examples{
# Get path to the example option file included with package
option_file <- system.file("extdata", "option.R", 
                          package = "BayesianFitForecast")
                          
# Specify the path to the Excel file you want to analyze
excel_file <- system.file("extdata", "SanFrancisco.xlsx", 
                          package = "BayesianFitForecast")  # Modify this path accordingly
                          
# Run the MCMC analysis
\donttest{
Run_MCMC(option_file = option_file, excel_file = excel_file, output_path = NULL)
}
}
