% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauchy.R
\name{bi.dist.cauchy}
\alias{bi.dist.cauchy}
\title{Cauchy Distribution}
\usage{
bi.dist.cauchy(
  loc = 0,
  scale = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{A numeric vector or scalar representing the location parameter. Defaults to 0.0.}

\item{scale}{A numeric vector or scalar representing the scale parameter. Must be positive. Defaults to 1.0.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector, optional, to mask observations. Defaults to `reticulate::py_none()`.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the distribution.  When `sample=False` (model building), this is used
with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is
used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).
Defaults to `reticulate::py_none()`.}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample
site. Defaults to `FALSE`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Cauchy distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Cauchy distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
Samples from a Cauchy distribution.

The Cauchy distribution, also known as the Lorentz distribution, is a continuous probability distribution
that arises frequently in various fields, including physics and statistics. It is characterized by its
heavy tails, which extend indefinitely. This means it has a higher probability of extreme values compared to the normal distribution.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.cauchy(sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#cauchy}
}
