/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.ValuesPool;
import dr.inference.model.Variable;

public class ParameterChooser
extends Variable.BaseNumerical<Double>
implements Variable<Double>,
ModelListener {
    private final ValuesPool pool;
    private final int[] which;
    private final Bounds<Double> bounds = new Bounds<Double>(){

        @Override
        public Double getUpperLimit(int n) {
            return ParameterChooser.this.pool.getBounds().getUpperLimit(ParameterChooser.this.which[n]);
        }

        @Override
        public Double getLowerLimit(int n) {
            return ParameterChooser.this.pool.getBounds().getLowerLimit(ParameterChooser.this.which[n]);
        }

        @Override
        public int getBoundsDimension() {
            return ParameterChooser.this.getSize();
        }
    };

    ParameterChooser(String string, ValuesPool valuesPool, int[] nArray) {
        super(string);
        this.pool = valuesPool;
        this.which = nArray;
        valuesPool.addModelListener(this);
    }

    @Override
    public int getSize() {
        return this.which.length;
    }

    @Override
    public Double getValue(int n) {
        return this.pool.getValue(this.which[n]);
    }

    @Override
    public void setValue(int n, Double d) {
        assert (false);
    }

    public Double[] getValues() {
        int n = this.getSize();
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = this.getValue(i);
        }
        return doubleArray;
    }

    @Override
    public void storeVariableValues() {
    }

    @Override
    public void restoreVariableValues() {
    }

    @Override
    public void acceptVariableValues() {
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        Bounds<Double> bounds2 = this.getBounds();
        assert (bounds.getBoundsDimension() == bounds2.getBoundsDimension());
        for (int i = 0; i < bounds.getBoundsDimension(); ++i) {
            if (!(bounds.getLowerLimit(i) > bounds2.getLowerLimit(i)) && !(bounds.getUpperLimit(i) < bounds2.getUpperLimit(i))) continue;
            throw new RuntimeException("can't do that");
        }
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        for (int i = 0; i < this.which.length; ++i) {
            if (!this.pool.hasChanged(this.which[i], object, n)) continue;
            this.fireVariableChanged(i);
        }
    }

    @Override
    public void modelRestored(Model model) {
    }
}

