% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomous_2k_2sid.R
\name{dichotomous_2k_2sid}
\alias{dichotomous_2k_2sid}
\title{Bivariate Chi squared and Fisher Test analysis for 2 categories.}
\usage{
dichotomous_2k_2sid(data, referencevar, flextableformat = TRUE)
}
\arguments{
\item{data}{Data frame from which variables will be extractred}

\item{referencevar}{Reference variable. Must have exactly 2 levels}

\item{flextableformat}{Logical operator to indicate the output desired. Default is TRUE. When FALSE, function will return a dataframe format.}
}
\value{
Returns a dataframe or flextable containing statistical values for Chi squared tests or Fisher's test.
}
\description{
Generates a HTML table of bivariate Chi squared and Fisher Test analysis for 2 categories. Display a table arranged dataframe with Chi squared statistic, minimum expected frecuencies, Chi squared p value, Fisher Test p value, and Odds ratio with 95 confidence levels. Note that you must recode factors and level the database factors in order to compute exact p values. Variable names can be assigned using \code{\link[table1:label]{table1::label()}} function.
}
\examples{
  # Not run

 # Create a sample dataframe
 df <- data.frame(
   has = c("Yes", "No", "Yes", "Yes", "No", "No", "Yes"),
   smoke = c("Yes", "No", "No", "Yes", "No", "Yes", "No"),
   gender = c("Male", "Female", "Male", "Female", "Female", "Male", "Male"))

 df$has <- as.factor(df$has)
 df$smoke <- as.factor(df$smoke)
 df$gender <- as.factor(df$gender)

# Set a value as reference level
 df$has <- relevel(df$has, ref= "Yes")
 df$smoke <- relevel(df$smoke, ref= "Yes")
 df$gender <- relevel(df$gender, ref= "Female")

 # Apply function
dichotomous_2k_2sid(df, referencevar="has")
dichotomous_2k_2sid(df, referencevar="has", flextableformat = FALSE)

# Set names to variables
if(requireNamespace("table1")){
table1::label(df$has) <- "Hypertension"
table1::label(df$smoke) <- "Smoking Habits"
table1::label(df$gender) <- "Gender"

dichotomous_2k_2sid(df, referencevar="has", flextableformat = FALSE)
}

}
\author{
JAFG
}
