% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts.R
\name{nuts}
\alias{nuts}
\alias{nuts_25N}
\alias{nuts_26N}
\title{Azorean NUTS}
\usage{
nuts(crs = laea_azores_proj())

nuts_25N()

nuts_26N()
}
\arguments{
\item{crs}{Coordinate reference system (CRS) passed on to
\link[sf:st_transform]{st_transform()}. Defaults to a custom CRS centered on
the Azores, see \code{\link[=laea_azores_proj]{laea_azores_proj()}} for more details. Other possible
options are \code{"EPSG: 3035"} for ETRS89-extended / LAEA Europe or
\code{"EPSG:4326"} for WGS 84.}
}
\value{
A simple features (\link[sf:sf]{sf}) object with seven fields:

\describe{
\item{\code{nuts_code}}{NUTS code.}
\item{\code{nuts_level}}{NUTS level.}
\item{\code{nuts_name}}{NUTS name.}
\item{\code{area}}{NUTS area in hectares (ha).}
\item{\code{perimeter}}{NUTS perimeter in kilometers.}
\item{\code{n_municipalities}}{Number of municipalities in the NUTS.}
\item{\code{n_parishes}}{Number of parishes in the NUTS.}
}
}
\description{
\code{\link[=nuts]{nuts()}} returns the boundaries of the Nomenclature of Territorial Units for
Statistics (NUTS).

\code{\link[=nuts_25N]{nuts_25N()}} returns the NUTS boundaries in the meter-based projection PTRA08
/ UTM zone 25N, i.e. the NUTS area in the western-most part of the
archipelago: \emph{Ilha das Flores} and \emph{Ilha do Corvo}.

\code{\link[=nuts_26N]{nuts_26N()}} returns the NUTS boundaries in the meter-based projection PTRA08
/ UTM zone 26N, i.e. the NUTS area in the Central and Eastern groups of
the archipelago.
}
\examples{
nuts()
nuts_25N()
nuts_26N()

}
