% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-and-validate-data.R
\name{check_enough_unique_temperatures_values}
\alias{check_enough_unique_temperatures_values}
\title{Check if the dataset contains enough unique temperature values}
\usage{
check_enough_unique_temperatures_values(dataset)
}
\arguments{
\item{dataset}{The input dataset containing the 'Temperature' column to be analyzed. The 'Temperature' column should be numeric representing temperature values.}
}
\value{
Logical value (TRUE or FALSE) indicating whether there are enough unique temperature values (at least 4) in the dataset.
}
\description{
Check if the dataset contains enough unique temperature values
}
\examples{
data <- data.frame(Temperature = c(25, 30, 25, 35, 28, 28))
check_enough_unique_temperatures_values(data)
# Output: TRUE
}
