% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzz.R
\name{whitelist}
\alias{whitelist}
\title{Apply additional whitelist patterns to the results of a fuzz run}
\usage{
whitelist(object, patterns)
}
\arguments{
\item{object}{An object of class \code{cbtf}.}

\item{patterns}{One or more strings containing regular expressions to
match the errors to whitelist.}
}
\value{
An object of class \code{cbtf} with the additional whitelist patterns applied.
}
\description{
This allows for post-hoc whitelisting of results according to the patterns
specified.
}
\examples{
## this reports a false positive result
(res <- fuzz(funs = "matrix", what = test_inputs("scalar")))

## with whitelisting, we can remove that
whitelist(res, "must be of a vector type")

}
\seealso{
\link{fuzz}
}
