% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detSigNumPipeline.R
\name{detSigNumPipeline}
\alias{detSigNumPipeline}
\title{detSigNumPipeline}
\usage{
detSigNumPipeline(
  segData,
  cores = 1,
  components = NULL,
  saveRes = FALSE,
  runName = "Run",
  rmin = 3,
  rmax = 12,
  max_comps = NULL,
  min_comps = NULL,
  saveDir = NULL,
  smooth = FALSE,
  colMap = NULL,
  pR = FALSE,
  gbuild = "hg19",
  featsToUse = NULL,
  ploidyData = NULL
)
}
\arguments{
\item{segData}{The data to be analyzed. If a path name, readSegs is used to
make the list. Otherwise the list must be formatted correctly. Refer to 
?readSegs for format information.}

\item{cores}{The number of computer cores to be used for parallel processing}

\item{components}{Can be used when fixing components. Default is NULL.}

\item{saveRes}{Whether or not to save the resulting tables and plots. 
Default is FALSE}

\item{runName}{Used to title plots and files when saving results}

\item{rmin}{Minimum number of signatures to look for. Default is 3.}

\item{rmax}{Maximum number of signatures to look for. Default is 12.}

\item{max_comps}{vector of length 6 specifying the max number of components 
for each feature. Passed to fitModels. Default is 10 for all features}

\item{min_comps}{vector of length 6 specifying the min number of components
for each feature. Passed to fitModels. Default is 2 for all features}

\item{saveDir}{Used to specify where to save the results, must be provided 
if using saveDir}

\item{smooth}{Whether or not to smooth the input data. Default is FALSE.}

\item{colMap}{Mapping of column names when reading from text file. 
Default column names are ID, chromosome, start, end, segVal.}

\item{pR}{Peak Reduction}

\item{gbuild}{The reference genome build. Default is hg19. Also supports hg18 and hg38.}

\item{featsToUse}{Vector of feature names that you wish to use}

\item{ploidyData}{The ploidy data to use as a feature}
}
\value{
Returns a list with all of the results from the pipeline
}
\description{
This function allows you to run the Copy number signature pipeline
up until the determineSigNum call. This is useful if you want to repeteadly
check the optimal number of signatures for different sample sets.
May take a while, especially if not given multiple cores.
}
\examples{
#Runs the entire pipeline on the example data giving it 6 cores and specifying
#5 signatures with a name of "TCGA Test"
\donttest{
detSigNumPipeline(segDataExp, cores = 6, saveRes = FALSE, runName = "TCGA Test")}
}
\keyword{detSigNum}
