% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSEcom.R
\name{MSEcom}
\alias{MSEcom}
\title{Caculate the MSE values of the COR criterion in simulation}
\usage{
MSEcom(K = K, nk = nk, alpha = alpha, X = X, y = y)
}
\arguments{
\item{K}{is the number of subsets}

\item{nk}{is the length of subsets}

\item{alpha}{is the significance level}

\item{X}{is the observation matrix}

\item{y}{is the response vector}
}
\value{
A list containing:
\item{MSEx}{The Mean Squared Error between the true beta and the estimate betax based on the COR.}
\item{MSEA}{The Mean Squared Error between the true beta and the estimate betaA based on the least squares estimate for subset A.}
\item{MSEc}{The Mean Squared Error between the true beta and the estimate betac based on the COR-selected subset.}
\item{MSEm}{The Mean Squared Error between the true beta and the median estimator betamm across all subsets.}
\item{MSEa}{The Mean Squared Error between the true beta and the mean estimator betaa across all subsets.}
}
\description{
Caculate the MSE values of the COR criterion in simulation
}
\examples{
p=6;n=1000;K=2;nk=500;alpha=0.05;sigma=1
e=rnorm(n,0,sigma); beta=c(sort(c(runif(p,0,1))));
data=c(rnorm(n*p,5,10));X=matrix(data, ncol=p);
y=X\%*\%beta+e;
MSEcom(K=K,nk=nk,alpha=alpha,X=X,y=y)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
