% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okm.R
\name{okm}
\alias{okm}
\title{Clusters data using the OKM (Overlapping K-Means) clustering algorithm.}
\usage{
okm(x, centers, iter.max = 10, nstart = 1, trace = FALSE, method = "euclid")
}
\arguments{
\item{x}{A numeric data matrix or data frame containing the data to be
clustered.}

\item{centers}{Either a positive integer indicating the number of clusters to
create or a matrix of pre-initialized cluster centers.}

\item{iter.max}{Maximum number of iterations allowed for the clustering
algorithm (default is 10).}

\item{nstart}{Number of random initializations to find the best result
(default is 1).}

\item{trace}{Logical value indicating whether to display the progress of the
algorithm (default is `FALSE`).}

\item{method}{A string specifying the distance metric to use; options are
'euclid' (Euclidean distance) or 'manhattan' (Manhattan distance)
(default is "euclid").}
}
\value{
A list containing the clustering results, including:
  - `cluster`: Matrix indicating the cluster assignments for each data point.
  - `centers`: The final cluster centers.
  - `tot.withinss`: Total within-cluster sum of squares.
  - `overlaps`: The measure of overlap among clusters.
}
\description{
Clusters data using the OKM (Overlapping K-Means) clustering algorithm.
}
\examples{
okm(iris[, -5], 3)
}
