% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeriodPET.R
\name{PeriodPET}
\alias{PeriodPET}
\title{Compute the Potential Evapotranspiration}
\usage{
PeriodPET(
  data,
  dates,
  lat,
  pet_method = "hargreaves",
  time_dim = "syear",
  leadtime_dim = "time",
  lat_dim = "latitude",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A named list of multidimensional arrays containing
the seasonal forecast experiment data for each variable. 
Specific variables are needed for each method used in computing the 
Potential Evapotranspiration (see parameter 'pet_method'). The accepted 
variable names are fixed in order to be recognized by the function. 
The accepted name corresponding to the Minimum Temperature is 'tmin', 
for Maximum Temperature is 'tmax', for Mean Temperature is 'tmean' and 
for Precipitation is 'pr'. The accepted variable names for each method are: 
For 'hargreaves': 'tmin' and 'tmax'; for 'hargreaves_modified' are 'tmin', 
'tmax' and 'pr'; for method 'thornthwaite' 'tmean' is required. The units 
for temperature variables ('tmin', 'tmax' and 'tmean') need to be in Celcius 
degrees; the units for precipitation ('pr') need to be in mm/month. 
Currently the function works only with monthly data from different years.}

\item{dates}{An array of temporal dimensions containing the Dates of 
'data'. It must be of class 'Date' or 'POSIXct'.}

\item{lat}{A numeric vector containing the latitude values of 'data'.}

\item{pet_method}{A character string indicating the method used to compute 
the potential evapotranspiration. The accepted methods are:
'hargreaves' and 'hargreaves_modified', that require the data to have 
variables tmin and tmax; and 'thornthwaite', that requires variable 
'tmean'.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'syear'.}

\item{leadtime_dim}{A character string indicating the name of the temporal 
dimension. By default, it is set to 'time'.}

\item{lat_dim}{A character string indicating the name of the latitudinal 
dimension. By default it is set by 'latitude'.}

\item{na.rm}{A logical value indicating whether NA values should be removed 
from data. It is FALSE by default.}

\item{ncores}{An integer value indicating the number of cores to use in 
parallel computation.}
}
\value{
A multidimensional array with the same dimensions as the input data, 
containing the computed Potential Evapotranspiration (PET) values in millimeters (\code{mm}).
}
\description{
Compute the Potential Evapotranspiration (PET) that is the amount of 
evaporation and transpiration that would occur if a sufficient water source 
were available. This function calculate PET according to the Thornthwaite, 
Hargreaves or Hargreaves-modified equations.
}
\details{
For more information on the SPEI calculation, see functions 
PeriodStandardization and PeriodAccumulation.
}
\examples{
dims <- c(time = 3, syear = 3, ensemble = 1, latitude = 1)
exp_tasmax <- array(rnorm(360, 27.73, 5.26), dim = dims)
exp_tasmin <- array(rnorm(360, 14.83, 3.86), dim = dims)
exp_prlr <- array(rnorm(360, 21.19, 25.64), dim = dims)
end_year <- 2012
dates_exp <- as.POSIXct(c(paste0(2010:end_year, "-08-16"), 
                         paste0(2010:end_year, "-09-15"), 
                         paste0(2010:end_year, "-10-16")), "UTC")
dim(dates_exp) <- c(syear = 3, time = 3)
lat <- c(40)
exp1 <- list('tmax' = exp_tasmax, 'tmin' = exp_tasmin, 'pr' = exp_prlr)
res <- PeriodPET(data = exp1, lat = lat, dates = dates_exp)

}
