% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_cste_bin.R
\name{select_cste_bin}
\alias{select_cste_bin}
\title{Select the optimal tuning parameters in CSTE estimation for binary outcome.}
\usage{
select_cste_bin(
  x,
  y,
  z,
  lam_seq,
  beta_ini = NULL,
  nknots = 1,
  max.iter = 2000,
  eps = 0.001
)
}
\arguments{
\item{x}{samples of covariates which is a \eqn{n*p} matrix.}

\item{y}{samples of binary outcome which is a \eqn{n*1} vector.}

\item{z}{samples of treatment indicator which is a \eqn{n*1} vector.}

\item{lam_seq}{a sequence for the choice of \eqn{\lambda}.}

\item{beta_ini}{initial values for \eqn{(\beta_1', \beta_2')'}, default value is NULL.}

\item{nknots}{number of knots for the B-spline for estimating \eqn{g_1} and \eqn{g_2}.}

\item{max.iter}{maximum iteration for the algorithm.}

\item{eps}{numeric scalar \eqn{\geq} 0, the tolerance for the estimation 
of \eqn{\beta_1} and \eqn{\beta_2}.}
}
\value{
A list which includes
\itemize{
   \item \code{optimal}: optimal cste within the given the sequence of \eqn{\lambda}.
   \item \code{bic}: BIC for the sequence of \eqn{\lambda}.
   \item \code{lam_seq}: the sequence of \eqn{\lambda} that is used.
   
}
}
\description{
select lasso penalty parameter \eqn{\lambda} for \eqn{\beta_1} and
\eqn{\beta_2} in CSTE estimation.
}
\references{
Guo W., Zhou X. and Ma S. (2021).
Estimation of Optimal Individualized Treatment Rules
Using a Covariate-Specific Treatment Effect Curve with 
High-dimensional Covariates,
\emph{Journal of the American Statistical Association}, 116(533), 309-321
}
\seealso{
\code{\link{cste_bin}}
}
