% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction_solvers.R
\docType{class}
\name{SolvingChain-class}
\alias{SolvingChain-class}
\alias{.SolvingChain}
\alias{prepend,SolvingChain,Chain-method}
\alias{reduction_solve,SolvingChain,Problem-method}
\alias{reduction_solve_via_data,SolvingChain-method}
\title{The SolvingChain class.}
\usage{
\S4method{prepend}{SolvingChain,Chain}(object, chain)

\S4method{reduction_solve}{SolvingChain,Problem}(
  object,
  problem,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts
)

\S4method{reduction_solve_via_data}{SolvingChain}(
  object,
  problem,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts
)
}
\arguments{
\item{object}{A \linkS4class{SolvingChain} object.}

\item{chain}{A \linkS4class{Chain} to prepend.}

\item{problem}{The problem to solve.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{data}{Data for the solver.}
}
\description{
This class represents a reduction chain that ends with a solver.
}
\section{Methods (by generic)}{
\itemize{
\item \code{prepend(object = SolvingChain, chain = Chain)}: Create and return a new SolvingChain by concatenating chain with this instance.

\item \code{reduction_solve(object = SolvingChain, problem = Problem)}: Applies each reduction in the chain to the problem, solves it,
and then inverts the chain to return a solution of the supplied problem.

\item \code{reduction_solve_via_data(SolvingChain)}: Solves the problem using the data output by the an apply invocation.

}}
