#' Ternary probability forecast and observations.
#'
#' 10,000 realizations of a ternary probability forecast, which exhibits different characteristics, 
#' depending on the realizing outcome variable. Idealized forecast example, generated as described in Wilks (2013).
#' 
#' @docType data
#' 
#' @usage data(ternary_forecast_example)
#' 
#' @format A data frame with 10,000 rows and 6 variables.
#' \describe{
#'   \item{p1}{forecast probability for outcome 1}
#'   \item{p3}{forecast probability for outcome 3}
#'   \item{obs0}{outcomes, such that the forecast is well-calibrated}
#'   \item{obs1}{outcomes, such that the forecast is overconfident}
#'   \item{obs2}{outcomes, such that the forecast is underconfident}
#'   \item{obs3}{outcomes, such that the forecast is unconditionally biased}
#' }
#' 
#' @references Daniel S. Wilks, 2013, The Calibration Simplex: A Generalization of the Reliability Diagram for Three-Category Probability Forecasts, \emph{Weather and Forecasting}, \strong{28}, 1210-1218
#' 
#' @source Data generated by package author.
#' 
"ternary_forecast_example"