% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valProbCluster.R
\name{valProbCluster}
\alias{valProbCluster}
\title{Calibration performance with cluster adjustment (ggplot version)}
\usage{
valProbCluster(
  data = NULL,
  p,
  y,
  cluster,
  plot = TRUE,
  approach = c("MIXC", "CGC", "MAC2"),
  cl.level = 0.95,
  xlab = "Predicted probability",
  ylab = "Observed proportion",
  grid_l = 100,
  rangeGrid = range(p),
  ...
)
}
\arguments{
\item{data}{optional, a data frame containing the variables \code{p}, \code{y},
and \code{cluster}. If supplied, variable names should be given without
quotation marks.}

\item{p}{predicted probabilities (numeric vector) or name of the column in \code{data}}

\item{y}{binary outcome variable or the name of the column in \code{data}}

\item{cluster}{cluster identifier (factor, character, or integer) or name of the column in \code{data}}

\item{plot}{logical, indicates whether a plot needs to be produced. If \code{TRUE}, a plot will be constructed by the chosen
subfunction.}

\item{approach}{character string specifying which calibration method to use.
Must be one of the following:
\itemize{
  \item \code{"\link{CGC}"}: Clustered Grouped Calibration;
  \item \code{"\link{MAC2}"}: Meta-Analytical Calibration Curve;
  \item \code{"\link{MIXC}"}: Mixed-Effects Model Calibration.
}
Defaults to \code{"MIXC"}.}

\item{cl.level}{the confidence level for the calculation of the confidence intervals. Default is \code{0.95}.}

\item{xlab}{label for the x-axis of the plot (default is \code{"Predicted probability"}).}

\item{ylab}{label for the y-axis of the plot (default is \code{"Observed proportion"}).}

\item{grid_l}{integer. Number of points in the probability grid for plotting
(default is \code{100}).}

\item{rangeGrid}{the range of the grid. Default is \code{range(p)}.}

\item{...}{additional arguments to be passed to the selected subfunction
(\code{\link{CGC}}, \code{\link{MAC2}} and \code{\link{MIXC}}).}
}
\value{
An object of class \code{"valProbCluster"} containing:
\itemize{
  \item \code{call}: the matched call.
  \item \code{approach}: the chosen approach.
  \item \code{cl.level}: the confidence level used.
  \item \code{grid}: probability grid used for plotting.
  \item \code{ggplot}: a \code{ggplot} object if returned by the subfunction,
        otherwise \code{NULL}.
  \item \code{results}: results from the chosen subfunction.
}
}
\description{
This function evaluates the calibration performance of a model's predicted probabilities
whilst accounting for clustering. The function supports multiple approaches
(`"CGC"`, `"MAC2"`, `"MIXC"`) and returns the results as well as a `ggplot` object.
}
\details{
The function internally calls one of the following subfunctions:
\itemize{
  \item \code{CGC(p, y, cluster, plot, ...)}
  \item \code{MAC2(p, y, cluster, plot, grid, ...)}
  \item \code{MIXC(p, y, cluster, plot, CI, grid, ...)}
}

Extra arguments supplied via the ellipsis argument \code{...} are passed directly to the chosen
subfunction. Please check the additional documentation of
\code{\link{CGC}}, \code{\link{MAC2}} and \code{\link{MIXC}} for detailed information on the arguments.
}
\examples{
\donttest{
library(lme4)
data("clustertraindata")
data("clustertestdata")
mFit = glmer(y ~ x1 + x2 + x3 + x5 + (1 | cluster),
             data = clustertraindata, family = "binomial")
preds          = predict(mFit, clustertestdata, type = "response", re.form = NA)
y              = clustertestdata$y
cluster        = clustertestdata$cluster
valClusterData = data.frame(y = y, preds = preds, center = cluster)

# Assess calibration performance
Results  = valProbCluster(
p = valClusterData$preds, y = valClusterData$y, cluster = valClusterData$center,
plot = TRUE,
approach = "MIXC", method = "slope", grid_l = 100
)
Results
}

}
\references{
Barreñada, L., De Cock Campo, B., Wynants, L., Van Calster, B. (2025).
Clustered Flexible Calibration Plots for Binary Outcomes Using Random Effects Modeling.
arXiv:2503.08389, available at https://arxiv.org/abs/2503.08389.
}
\seealso{
\code{\link{CGC}}, \code{\link{MAC2}} and \code{\link{MIXC}}
}
