% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{emotion_heartrate_df}
\alias{emotion_heartrate_df}
\title{Anger recall effect on heart rate (Lakens, 2013)}
\format{
A data frame with 68 observations and 3 variables:
\describe{
  \item{ID}{Participant identification number (integer vector)}
  \item{HR_baseline}{Baseline heart rate in beats per minute (numeric vector)}
  \item{HR_anger}{Heart rate during anger recall in beats per minute (numeric vector)}
}
}
\source{
Data taken from the esci package version 1.0-7. Original study:
Lakens D (2013). Conceptual replication of Ekman et al. (1983) emotion study.
}
\usage{
data(emotion_heartrate_df)
}
\description{
This dataset, emotion_heartrate_df, is a data frame containing heart rate measurements
from a study investigating how recalling anger affects heart rate. It includes baseline
and anger-induced heart rate measurements from 68 participants.
}
\details{
The dataset name has been kept as 'emotion_heartrate_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
