% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs_ad.R
\name{catr_wfs_get_address_bbox}
\alias{catr_wfs_get_address_bbox}
\alias{catr_wfs_get_address_codvia}
\alias{catr_wfs_get_address_rc}
\alias{catr_wfs_get_address_postalcode}
\title{WFS INSPIRE: Download addresses}
\usage{
catr_wfs_get_address_bbox(x, srs, verbose = FALSE)

catr_wfs_get_address_codvia(codvia, del, mun, srs = NULL, verbose = FALSE)

catr_wfs_get_address_rc(rc, srs = NULL, verbose = FALSE)

catr_wfs_get_address_postalcode(postalcode, srs = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See \strong{Details}. It could be:
\itemize{
\item A numeric vector of length 4 with the coordinates that defines
the bounding box: \code{c(xmin, ymin, xmax, ymax)}
\item A \code{sf/sfc} object, as provided by the \CRANpkg{sf} package.
}}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{wfs_service} column. See \strong{Details}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{codvia}{Cadastral street code.}

\item{del}{Cadastral office code.}

\item{mun}{Cadastral municipality code.}

\item{rc}{The cadastral reference to be extracted.}

\item{postalcode}{Postal code.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Get the spatial data of addresses The WFS Service allows to perform
several types of queries:
\itemize{
\item By bounding box: Implemented on \code{catr_wfs_get_address_bbox()}.
Extract objects included on the bounding box provided. See \strong{Details}.
}

\itemize{
\item By street code: Implemented on \code{catr_wfs_get_address_codvia()}. Extract
objects of specific addresses.
}

\itemize{
\item By cadastral reference: Implemented on \code{catr_wfs_get_address_rc()}. Extract
objects of specific cadastral references
}

\itemize{
\item By postal codes: Implemented on \code{catr_wfs_get_address_postalcode()}.
Extract objects of specific cadastral references
}
}
\details{
When \code{x} is a numeric vector, make sure that the \code{srs} matches the
coordinate values. Additionally, when the \code{srs} correspond to a geographic
reference system (4326, 4258), the function queries the bounding box on
\href{https://epsg.io/3857}{EPSG:3857} - Web Mercator, to overcome
a potential bug on the API side.

When \code{x} is a \code{\link[sf:sf]{sf}} object, the value \code{srs} is ignored. In
this case, the bounding box of the \code{\link[sf:sf]{sf}} object would be
used for the query (see \code{\link[sf:st_bbox]{sf::st_bbox()}}). The query is performed using
\href{https://epsg.io/3857}{EPSG:3857} (Web Mercator). The result is provided
always in the SRS of the \code{\link[sf:sf]{sf}} object provided as input.
}
\section{API Limits}{
The API service is limited to a bounding box of 4km2 and a maximum of 5.000
elements.
}

\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
ad <- catr_wfs_get_address_bbox(
  c(
    233673, 4015968, 233761, 4016008
  ),
  srs = 25830
)

library(ggplot2)

ggplot(ad) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.catastro.hacienda.gob.es/webinspire/documentos/inspire-ad-WFS.pdf}{API Documentation}.

\href{https://www.catastro.hacienda.gob.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}.
}
\seealso{
\code{\link[sf:st_bbox]{sf::st_bbox()}}

INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE WFS services:
\code{\link{catr_srs_values}},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()}

Other addresses: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()}

Other spatial: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{INSPIRE}
\concept{WFS}
\concept{addresses}
\concept{spatial}
