% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHostParams.R
\name{checkInstallDir}
\alias{checkInstallDir}
\title{Verify NLME Installation Directory}
\usage{
checkInstallDir(installDir)
}
\arguments{
\item{installDir}{A character string specifying the path to the NLME
installation directory to be checked.}
}
\value{
Returns `TRUE` if all required files are found and permissions are
successfully set (on Unix). Returns `FALSE` if the validation fails.
}
\description{
Checks if a specified directory contains all the required files for the NLME
engine to operate. It performs platform-specific checks for Unix-like
systems and Windows.
}
\details{
The function validates the presence of essential executables, libraries, and
scripts.

On Unix systems, if the `PML_BIN_DIR` environment variable is set
(e.g., to "UBUNTU" or "RHEL"), the function searches for files within that
subdirectory of `installDir`. If the variable is not set, it searches
directly in `installDir`.

On Windows, it checks for `.exe`, `.dll`, and `.ps1` files directly within
the specified `installDir`.
}
\section{Side Effects}{

- On Unix systems, upon successful validation, it sets execute permissions
  (`0777`) on the "TDL5" executable and the "execNLMECmd.sh" script
  using `Sys.chmod()`.
}

\examples{
\dontrun{
checkInstallDir(Sys.getenv("INSTALLDIR"))
}

}
