% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pyDarwinRemote.R
\name{run_pyDarwinRemote}
\alias{run_pyDarwinRemote}
\title{Run pyDarwin on a Remote Host via SSH}
\usage{
run_pyDarwinRemote(
  Host,
  User,
  Password = "",
  KeyPath = Sys.getenv("SSH_PRIVATE_KEY_PATH"),
  SshFlags = character(0),
  LocalTemplatePath,
  LocalTokensPath,
  LocalOptionsPath,
  LocalDirectoryPath = ".",
  RemoteBaseDir = "~/.rdarwin/",
  RemoteInterpreterPath = NULL,
  UseLocalLicense = FALSE,
  Wait = TRUE,
  Flags = c("-u", "-m"),
  MonitoringInterval = 30
)
}
\arguments{
\item{Host}{Character string. The hostname or IP address of the remote server.}

\item{User}{Character string. The username for the SSH connection.}

\item{Password}{Character string. The password for SSH authentication. Defaults
to \code{""}, which is appropriate when using key-based authentication. Using
keys is strongly recommended over embedding passwords in scripts.}

\item{KeyPath}{Character string. The path to your private SSH key file.
Defaults to the path stored in the \code{SSH_PRIVATE_KEY_PATH} environment variable.}

\item{SshFlags}{Character vector. Additional flags to pass to the underlying
\code{ssh::ssh_connect} function.}

\item{LocalTemplatePath}{Character string. The path to the pyDarwin template
file. If not provided, defaults to \code{"template.txt"} within \code{LocalDirectoryPath}.}

\item{LocalTokensPath}{Character string. The path to the pyDarwin tokens JSON
file. If not provided, defaults to \code{"tokens.json"} within \code{LocalDirectoryPath}.}

\item{LocalOptionsPath}{Character string. The path to the pyDarwin options
JSON file. If not provided, defaults to \code{"options.json"} within \code{LocalDirectoryPath}.}

\item{LocalDirectoryPath}{Character string or \code{NULL}. The path to the local
project directory that contains the pyDarwin input files. Defaults to the
current working directory (\code{.}). If \code{NULL} is provided, the directory
containing \code{LocalOptionsPath} is used as the project directory.}

\item{RemoteBaseDir}{Character string. The base directory on the remote host
under which a new project-specific directory will be created.}

\item{RemoteInterpreterPath}{Character string or \code{NULL}. The full path to the
Python interpreter on the remote host (e.g., \verb{/usr/bin/python3}). If \code{NULL},
the function attempts to find a suitable Python interpreter automatically.}

\item{UseLocalLicense}{Logical. If \code{TRUE}, attempts to transfer local Certara
license files to the remote host.}

\item{Wait}{Logical. If \code{TRUE} (the default), the function will monitor the
remote job's progress and download the results upon completion. If \code{FALSE},}

\item{Flags}{Character vector. Command-line flags to pass to the \code{pyDarwin}
Python module.}

\item{MonitoringInterval}{Numeric. The interval in seconds between status
checks when monitoring a running job (\code{Wait = TRUE}).}
}
\value{
The return value depends on the \code{Wait} parameter:
\item{If \code{Wait = TRUE}}{On successful completion, a list containing the
parsed results, similar to \code{run_pyDarwin()}. This may include data frames
like \verb{$results} and character vectors like \verb{$FinalResultFile}.}
\item{If \code{Wait = FALSE}}{An invisible list containing information needed to
reconnect to the job later using \code{reconnect_pyDarwinJob()}. The list includes:
\itemize{
\item \code{LocalJobInfoFile}: Path to the local JSON file with job details.
\item \code{RemoteProjectDir}: The directory on the remote host.
\item \code{RemoteJobPID}: The Process ID of the job on the remote host.
\item \code{Host}, \code{User}, \code{ProjectName}
}}
The function throws an error if a critical step fails.
}
\description{
Establishes an SSH connection, prepares and uploads project files, executes
pyDarwin in the background, and can optionally monitor the job and download
results upon completion.
}
\details{
This function automates the entire remote execution workflow. It creates a
unique project directory on the remote host to ensure run isolation.
}
\examples{
\dontrun{
# Example of launching a remote job and waiting for the results
remote_results <- run_pyDarwinRemote(
  Host = "cluster.mycompany.com",
  User = "myuser",
  KeyPath = "~/.ssh/id_rsa_cluster",
  LocalDirectoryPath = "path/to/my/CovariateSearchProject"
)

# Example of launching a job in the background
job_info <- run_pyDarwinRemote(
  Host = "cluster.mycompany.com",
  User = "myuser",
  KeyPath = "~/.ssh/id_rsa_cluster",
  LocalDirectoryPath = "path/to/my/CovariateSearchProject",
  Wait = FALSE
)

# You can later use job_info to reconnect to the job
# final_results <- reconnect_pyDarwinJob(JobInfo = job_info)
}
}
\seealso{
\code{\link[=create_pyDarwinOptions]{create_pyDarwinOptions()}}, \code{\link[=reconnect_pyDarwinJob]{reconnect_pyDarwinJob()}}
}
