% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_pyDarwinRemote.R
\name{stop_pyDarwinRemote}
\alias{stop_pyDarwinRemote}
\title{Stop a Remote pyDarwin Job}
\usage{
stop_pyDarwinRemote(
  LocalDirectoryPath,
  LocalJobInfoFilePath = NULL,
  OriginalOptionsPath = NULL,
  Password = NULL,
  KeyPath = NULL,
  verbose = getOption("verbose", default = FALSE)
)
}
\arguments{
\item{LocalDirectoryPath}{Character string: The base local directory associated
with the pyDarwin job. This directory is used to locate the job
information file and the original options file.}

\item{LocalJobInfoFilePath}{Character string (optional): Explicit path to the local
JSON file containing remote job information. If NULL (default), it's
constructed using \code{LocalDirectoryPath} and \code{ProjectName} (derived from
\code{OriginalOptionsPath}).}

\item{OriginalOptionsPath}{Character string (optional): Explicit path to the original
local \code{options.json} file. If NULL (default), it's sought in
\code{LocalDirectoryPath}. This is used to derive \code{ProjectName} if needed.}

\item{Password}{Character string. The password for SSH authentication. Defaults
to \code{""}, which is appropriate when using key-based authentication. Using
keys is strongly recommended over embedding passwords in scripts.}

\item{KeyPath}{Character string. The path to your private SSH key file.
Defaults to the path stored in the \code{SSH_PRIVATE_KEY_PATH} environment variable.}

\item{verbose}{Logical: Passed to \code{ssh::ssh_connect} for verbose SSH output.
Default: \code{getOption("verbose", default = FALSE)}.}
}
\value{
Invisibly returns \code{TRUE} if the stop signal file was successfully created
(or already existed), and \code{FALSE} if there was an SSH error or an error
creating the file. This only signals the intent to stop; it does not
confirm the pyDarwin process has actually stopped.
}
\description{
Attempts to gracefully stop a running pyDarwin job on a remote host by
creating a 'stop.darwin' file in the remote project directory.
}
\examples{
\dontrun{
# Assuming 'my_project_remote_job_info.json' and 'options.json'
# exist in '~/darwin_runs/my_project_run'.
try({
  stop_pyDarwinRemote(
    LocalDirectoryPath = "~/darwin_runs/my_project_run",
    KeyPath = "~/.ssh/id_rsa_remote"
  )
})

# Explicitly providing paths
try({
 stop_pyDarwinRemote(
   LocalDirectoryPath = "~/darwin_runs/my_project_run", # Still used as a base if needed
   LocalJobInfoFilePath = "~/darwin_runs/my_project_run/my_project_remote_job_info.json",
   OriginalOptionsPath = "~/darwin_runs/my_project_run/options.json"
 )
})
}
}
