% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelExecutorUI.R
\name{modelExecutorUI}
\alias{modelExecutorUI}
\title{Run Model Executor}
\usage{
modelExecutorUI(
  model,
  hosts,
  wd,
  outputfile = "shiny_dirs.txt",
  metamodelFileName = "temp.mmdl",
  fromPirana = FALSE
)
}
\arguments{
\item{model}{Model object generated from \code{Certara.RsNLME}.}

\item{hosts}{One or more hosts generated from \code{Certara.RsNLME::hostParams()}.
If missing, the default local host will be used.}

\item{wd}{Working directory where the model output folders will be created.
If missing, the directory specified in the model object will be used \code{model@modelInfo@workingDir}.}

\item{outputfile}{Text file providing a list of model output subfolders generated inside \code{wd} during the Shiny session. Only applicable for Pirana.}

\item{metamodelFileName}{Name of the resulting metamodel to generate. Only applicable for Pirana.}

\item{fromPirana}{Logical; set to \code{TRUE} when launching app from Pirana.}
}
\value{
Deploys a Shiny app to execute a \code{Certara.RsNLME} model. Returns \code{NULL} if assigned to an object.
}
\description{
Used to execute a model developed in \code{Certara.RsNLME} from a Shiny GUI.
}
\examples{
if (interactive()) {
model <- Certara.RsNLME::pkmodel(
  parameterization = "Clearance",
  absorption = "Intravenous",
  numCompartments = 2,
  data = Certara.RsNLME::pkData,
  ID = "Subject",
  A1 = "Amount",
  Time = "Act_Time",
  CObs = "Conc",
  modelName = "pk_model")


modelExecutorUI(model)

}
 
}
