join_d1Etas <- function(d1, random) {
  # proceeding etas in dmp
  # note that row names of the etas matrix are not correct in case
  # of multiple IDs; but we are using unique residuals IDs here
  # since the order is the same
  nrandom <- dplyr::bind_cols(random, ID = unique(d1$ID))

  d1 <- dplyr::left_join(d1, nrandom,
                         by = "ID",
                         suffix = c("_input", "")
  )

  list(d1 = d1, rnames = colnames(random))
}
