% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggNlme.R
\name{nlme.ranpar.vs.cov}
\alias{nlme.ranpar.vs.cov}
\title{Plot random parameter estimates against covariates}
\usage{
nlme.ranpar.vs.cov(xpdb, covColNames, nrow = 1, ncol = 1, ...)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{covColNames}{Character vector of covariates to build the matrix.}

\item{nrow}{Number of rows.}

\item{ncol}{Number of columns; if ncol=1, each gtable object is treated separately.}

\item{...}{Parameters to be passed to \code{\link[egg]{ggarrange}()}}
}
\value{
List of \code{\link[gtable]{gtable}}
}
\description{
Use to create a stack of plots of random parameter estimates plotted against covariates.
}
\examples{
nlme.ranpar.vs.cov(xpdb = xpose::xpdb_ex_pk,
covColNames = c("SEX", "CLCR", "AGE")
)

}
