test_that("xpose used for emax time-based model with 2cat1cont covs ", {
  workingDir <- system.file("extdata/Emax_Baseline_2Cat1ContCovariates",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )
  modelName <- "Emax_Baseline_2Cat1ContCovariates"
  ConvergenceData <- read.csv(file.path(workingDir, "ConvergenceData.csv"))
  xpdb <- xposeNlme(
    dir = workingDir,
    modelName = modelName,
    dmpFile = "dmp.txt",
    dataFile = "data1.txt",
    logFile = "nlme7engine.log",
    ConvergenceData = ConvergenceData
  )


  results <- xpdb$data$index[[1]]
  testthat::local_edition(3)
  testthat::expect_snapshot(as.data.frame(xpdb$data$index[[1]]))
  dataset <- xpdb$data$data[[1]]
  testthat::expect_equal(as.character(dataset$ID), paste(dataset$Study, dataset$Subject, sep = "_"))
})
