test_that("xposeNlmeModel works with time-based model  ", {
  inputDir <- system.file("extdata/TwCpt_IVBolus_FOCE_ELS",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )

  requireNamespace("Certara.RsNLME", quietly = TRUE)
  load(file.path(inputDir, "TwCpt_IVBolus_model.RData"))
  load(file.path(inputDir, "TwCpt_IVBolus_result.RData"))

  xpdb <- xposeNlmeModel(
    model = model,
    fitmodelOutput = job
  )


  testthat::local_edition(3)
  testthat::expect_snapshot(tail(as.data.frame(xpdb$data$data[[1]])))
})

test_that("xposeNlmeModel works with Reset ", {
  inputDir <- system.file("extdata/ThreeCpt_IVIM_Naive",
                          package = "Certara.Xpose.NLME",
                          mustWork = TRUE
  )

  requireNamespace("Certara.RsNLME", quietly = TRUE)
  load(file.path(inputDir, "ThreeCpt_IVIM_Naive_Model.RData"))
  load(file.path(inputDir, "ThreeCpt_IVIM_Naive_Results.RData"))

  xpdb <- xposeNlmeModel(
    model = model0,
    fitmodelOutput = model0fit
  )


  testthat::local_edition(3)
  testthat::expect_snapshot(tail(as.data.frame(xpdb$data$data[[1]])))
})
