% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{bj_air_quality_tbl_df}
\alias{bj_air_quality_tbl_df}
\title{Beijing Air Quality Dataset (2015)}
\format{
A tibble with 7,680 observations and 6 variables:
\describe{
  \item{DATE}{Date of observation (Date)}
  \item{HOUR}{Hour of the day (integer, from 0 to 23)}
  \item{NO2}{Nitrogen dioxide concentration (numeric)}
  \item{O3}{Ozone concentration (numeric)}
  \item{TEMP}{Temperature in degrees Celsius (numeric)}
  \item{WIND}{Wind speed in meters per second (numeric)}
}
}
\source{
Data taken from the gmgm package version 1.1.2
}
\usage{
data(bj_air_quality_tbl_df)
}
\description{
This dataset, bj_air_quality_tbl_df, is a tibble containing hourly air pollutant and weather measurements
from the Dongsi air quality monitoring site in Beijing, China. The data covers 320 complete days of the year 2015
and includes variables such as nitrogen dioxide (NO\eqn{_2}), ozone (O\eqn{_3}), temperature, and wind speed.
}
\details{
The dataset name has been kept as 'bj_air_quality_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChinAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble (a modern form of data frame). The original content has not been modified
in any way.
}
