% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_ancestral_states.r
\name{reconstruct_ancestral_states}
\alias{reconstruct_ancestral_states}
\title{Determine maximum parsimony ancestral state reconstruction(s)}
\usage{
reconstruct_ancestral_states(
  trees,
  cladistic_matrix,
  estimate_all_nodes = FALSE,
  estimate_tip_values = FALSE,
  inapplicables_as_missing = FALSE,
  polymorphism_behaviour = "uncertainty",
  uncertainty_behaviour = "uncertainty",
  polymorphism_geometry,
  polymorphism_distance,
  state_ages,
  dollo_penalty
)
}
\arguments{
\item{trees}{A tree (phylo object) or set of trees (multiPhylo object).}

\item{cladistic_matrix}{A character-taxon matrix in the format imported by \link{read_nexus_matrix}. These should be discrete with labels matching the tip labels of \code{tree}.}

\item{estimate_all_nodes}{Logical that allows the user to make estimates for all ancestral values. The default (\code{FALSE}) will only make estimates for nodes that link coded terminals (recommended).}

\item{estimate_tip_values}{Logical that allows the user to make estimates for tip values. The default (\code{FALSE}) will only makes estimates for internal nodes (recommended).}

\item{inapplicables_as_missing}{Argument passed to \link{calculate_tree_length}.}

\item{polymorphism_behaviour}{Argument passed to \link{calculate_tree_length}.}

\item{uncertainty_behaviour}{Argument passed to \link{calculate_tree_length}.}

\item{polymorphism_geometry}{Argument passed to \link{make_costmatrix}.}

\item{polymorphism_distance}{Argument passed to \link{make_costmatrix}.}

\item{state_ages}{Argument passed to \link{make_costmatrix}.}

\item{dollo_penalty}{Argument passed to \link{make_costmatrix}.}
}
\value{
A list with multiple components, including:

\item{ITEM}{ITEM EXPLANATION.}
}
\description{
Given a tree, or set of trees, and a cladistic matrix returns all most parsimonious reconstruction(s) for every character.
}
\details{
Although most phylogenetic inference considers character evolution on a tree, they rarely explicitly assign states to internal nodes in the process, and hence this is normally done \emph{a posteriori} using some form of ancestral state estimation algorithm. This function uses the parsimony optimality criterion (i.e., maximum parsimony, or the process that involves the fewest possible transitions, or, more accurately, the lowest total transition cost).

\bold{Algorithm}

Like \link{calculate_tree_length}, this function is built around the generalised Swofford and Maddison (1992) algorithm, but adds the second pass as this is the one that explicitly generates \emph{all} most parsimonious reconstructions. As it is a generalised approach it can work with the broadest range of character types and (rooted) trees of any degree of resolution - treating polytomies as hard.
}
\examples{

# Generate two trees:
trees <- ape::read.tree(text = c("(A,(B,(C,(D,E))));", "(A,((B,C),(D,E)));"))

# Build a simple 5-by-10 binary character matrix:
cladistic_matrix <- build_cladistic_matrix(
  character_taxon_matrix = matrix(
    data = sample(
      x = c("0", "1"), # ADD MISSING, POLYMORPHISM, INAPPLICABLE ETC. HERE LATER TO TEST
      size = 50,
      replace = TRUE
    ),
    nrow = 5,
    ncol = 10,
    dimnames = list(
      LETTERS[1:5],
      c()
    )
  )
)

# Reconstruct ancestral states (limiting output to all most parsimonious
# ancestral state reconstruction for every tree and character combination):
reconstruct_ancestral_states(
  trees = trees,
  cladistic_matrix = cladistic_matrix,
  estimate_all_nodes = FALSE,
  estimate_tip_values = FALSE,
  inapplicables_as_missing = FALSE,
  polymorphism_behaviour = "uncertainty",
  uncertainty_behaviour = "uncertainty",
  polymorphism_geometry = "simplex",
  polymorphism_distance = "euclidean",
  dollo_penalty = 999,
  state_ages = c(2, 1)
)$node_estimates

}
\references{
Lloyd, G. T., 2018. Journeys through discrete-character morphospace: synthesizing phylogeny, tempo, and disparity. \emph{Palaeontology}, \bold{61}, 637-645.

Swofford, D. L. and Maddison, W. P., 1992. Parsimony, character-state reconstructions, and evolutionary inferences. \emph{In} R. L. Mayden (ed.) Systematics, Historical Ecology, and North American Freshwater Fishes. Stanford University Press, Stanford, p187-223.
}
\seealso{
\link{calculate_tree_length}, \link{estimate_ancestral_states}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
