% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Universityfunds.R
\docType{data}
\name{Universityfunds}
\alias{Universityfunds}
\title{University funds data}
\format{
A data frame with 27 rows and 3 variables:


\tabular{rlll}{
[,1] \tab \code{Degree}   \tab categorical \tab Degree courses in a University\cr
[,2] \tab \code{Entitlement}  \tab numeric \tab  Objective entitlements based on number of students, experimental level, ... (euros)\cr
[,3] \tab \code{Claim}   \tab numeric \tab Claim of each degree (euros)\cr
}
}
\source{
The data were obtained from Pulido et al (2002).
}
\usage{
Universityfunds
}
\description{
Data to distribute a certain amount of money to buy equipment for
teaching laboratories among the different degree courses in the Universidad Miguel Hernández of Elche (Spain)
}
\examples{
data(Universityfunds)
head(Universityfunds)

E = 717293.11
d <- Universityfunds$Claim-Universityfunds$Entitlement
E = E-sum(Universityfunds$Entitlement)
Universityfunds$Entitlement+CEA(E,d)
Universityfunds$Entitlement+PRO(E,d)
}
\references{
Pulido, M., Sánchez Soriano, J., and Llorca, N. (2002). Game Theory Techniques for University Management: An Extended Bankruptcy Model.
Annals of Operations Research, 109, 129-142.

Pulido, M., Borm, P, Hendricks, R,  Llorca, N., and Sánchez Soriano, J. (2008). Compromise solutions for bankruptcy situations with references.
Annals of Operations Research, 158, 133-141.

Núñez Lugilde, I., Estévez Fernández, A., and Sánchez Rodríguez, E. (2024). Priority coalitional games and claims problems. Mathematical Methods of Operations Research, 100, 669–701.
}
\keyword{datasets}
