% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/giniindex.R
\name{giniindex}
\alias{giniindex}
\title{Gini index}
\usage{
giniindex(E, d, Rule)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rule}{A rule: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}
}
\value{
The Gini index of a rule for a claims problem and the Gini index of the vector of claims.
}
\description{
This function returns the Gini index of any rule for a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}.
The Gini index is a number aimed at measuring the degree of inequality in a distribution.
The Gini index of the rule \eqn{\mathcal{R}} for the problem \eqn{(E,d)}, denoted by \eqn{G(\mathcal{R},E,d)}, is
the ratio of the area that lies between the identity line and the Lorenz curve of the rule over the total area under the identity line.

Let \eqn{\mathcal{R}_0(E,d)=0}. For each \eqn{k=0,\dots,n} define
\eqn{X_k=\frac{k}{n}} and \eqn{Y_k=\frac{1}{E} \sum_{j=0}^{k} \mathcal{R}_j(E,d)}. Then,
\deqn{G(\mathcal{R},E,d)=1-\sum_{k=1}^{n}\Bigl(X_{k}-X_{k-1}\Bigr)\Bigl(Y_{k}+Y_{k-1}\Bigr).}
In general \eqn{0\le G(\mathcal{R},E,d) \le 1}.
}
\examples{
E=10
d=c(2,4,7,8)
Rule=AA
giniindex(E,d,Rule)
# The Gini index of the proportional awards coincides with the Gini index of the vector of claims
giniindex(E,d,PRO)
}
\references{
Ceriani, L. and Verme, P. (2012). The origins of the Gini index: extracts from Variabilitá e Mutabilitá (1912) by Corrado Gini. The Journal of Economic Inequality 10(3), 421-443.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2023). Deviation from proportionality and Lorenz-domination for claims problems. Review of Economic Design 27, 439-467.
}
\seealso{
\link{cumawardscurve}, \link{deviationindex}, \link{indexgpath},  \link{lorenzcurve}, \link{lorenzdominance}.
}
