% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{weighted_element_consistency}
\alias{weighted_element_consistency}
\title{Weighted Element-Centric Consistency}
\usage{
weighted_element_consistency(
  clustering_list,
  weights = NULL,
  calculate_sim_matrix = FALSE
)
}
\arguments{
\item{clustering_list}{The list of clustering results, each of which is either:
\itemize{
\item A numeric/character/factor vector of cluster labels for each element.
\item A samples x clusters matrix/Matrix::Matrix of nonzero membership values.
\item An hclust object.
}}

\item{weights}{A numeric vector of weights for each clustering in
\code{clustering_list}. If \code{NULL}, then all weights will be equal to 1. Defaults
to \code{NULL}.}

\item{calculate_sim_matrix}{A logical value that indicates whether to
calculate the similarity matrix or not along with the consistency score.
Defaults to \code{FALSE}.}
}
\value{
A vector containing the weighted element-wise consistency. If
\code{calculate_sim_matrix} is set to \code{TRUE}, the element similarity matrix
will be returned as well.
}
\description{
Calculate the weighted element-centric consistency of a set of
clusterings. The weights are used to give more importance to some clusterings
over others.
}
\note{
The weighted ECC will be calculated as \eqn{\displaystyle \frac{\sum_{i} \sum_{j} w_i w_j ECS(i, j)}{\sum_{i} w_i}}
}
\examples{
# cluster across 20 random seeds
clustering_list <- lapply(1:20, function(x) kmeans(mtcars, centers = 3)$cluster)
weights <- sample(1:10, 20, replace = TRUE)
weighted_element_consistency(clustering_list, weights = weights)
}
