% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustvar2.R
\name{hclustvar2}
\alias{hclustvar2}
\title{Hierarchical clustering of variables from a covariance matrix}
\usage{
hclustvar2(x, init = NULL)
}
\arguments{
\item{x}{a covariance or correlation matrix.}

\item{init}{an initial partition (a vector of integers indicating the
cluster to which each variable is allocated).}
}
\value{
\item{height }{a set of p-1 non-decreasing real values: the values of the aggregation criterion. } 
\item{clusmat }{a p by p matrix with group
memberships where each column k corresponds to the elements of the
partition in k clusters.} 
\item{merge }{a p-1 by 2 matrix.  Row i of \code{merge} describes the merging of clusters at step i of the clustering.
If an element j in the row is negative, then observation -j was merged at
this stage.  If j is positive then the merge was with the cluster formed at
the (earlier) stage j of the algorithm.  Thus negative entries in \code{merge} indicate agglomerations of singletons, and positive entries
indicate agglomerations of non-singletons. }
}
\description{
Ascendant hierarchical clustering of a set of variables from a covariance/correlation matrix.
}
\examples{
data(decathlon)
x <- cor(decathlon[,1:10])
tree <- hclustvar2(x)
plot(tree, hang = -1, xlab="", sub="")

}
\seealso{
\code{\link{cutreevar}}, \code{\link{plot.hclustvar}},
\code{\link{stability}}
}
\keyword{cluster}
\keyword{multivariate}
