% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_fgmod.R
\name{cfp_fgmod}
\alias{cfp_fgmod}
\title{Model frame for fg_flux}
\usage{
cfp_fgmod(
  x,
  gases = unique_gases(x),
  modes = "LL",
  param = c("c_air", "DS"),
  funs = c("arith", "harm")
)
}
\arguments{
\item{x}{A \code{cfp_dat} object with all the necessary input datasets.}

\item{gases}{(character) A character vector defining the gases for which
fluxes shall be calculated.}

\item{modes}{(character) A character vector specifying mode(s) for dcdz
calculation. Can be \code{"LL"},\code{"LS"},\code{"EF"}.
\describe{
\item{LL}{local linear approach: within each layer a linear model is
evaluated of concentration over the depth.}
\item{LS}{linear spline approach: A linear spline is fitted over the
complete profile with nodes at the layer intersections.}
\item{EF}{exponential fit approach: An exponential function of form
y=a+b*x^c is fit of concentration against depth. Using the first derivative
of that function the concentration gradient is evaluated for each layer.}
\item{DA}{exponential fit approach: An exponential function of form
\code{y=a+b*(1-exp(-a*x))} is fit of concentration against depth. Using the
first derivative of that function the concentration gradient is evaluated
for each layer. From Davidson (2006).}
}}

\item{param}{(character) A vector containing the the parameters of soilphys,
for which means should be calculated, must contain "c_air" and "DS", more
parameters may help interpretation.}

\item{funs}{(character) A vector defining the type of mean to be used for
each parameter in \code{param}. One of "arith" or "harm".}
}
\value{
A \code{cfp_fgmod} object. This inherits from \code{\link[=cfp_dat]{cfp_dat()}} and
adds model specific parameters.
}
\description{
An S3 class for \code{fg_flux()} models. The class inherits from
cfp_dat and adds any model specific parameters.
}
\examples{
cfp_fgmod(ConFluxPro::base_dat)

### coercion from other object types (internal)
fg_flux(ConFluxPro::base_dat) |>
  as_cfp_fgmod()

}
\references{
DAVIDSON, E. A., SAVAGE, K. E., TRUMBORE, S. E., & BORKEN, W. (2006).
Vertical partitioning of CO2 production within a temperate forest soil.
In Global Change Biology (Vol. 12, Issue 6, pp. 944–956). Wiley.
https://doi.org/10.1111/j.1365-2486.2005.01142.x
}
\seealso{
Other model frames: 
\code{\link{cfp_altres}()},
\code{\link{cfp_fgres}()},
\code{\link{cfp_pfmod}()},
\code{\link{cfp_pfres}()}
}
\concept{model frames}
