% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treepaths.R
\name{treepaths}
\alias{treepaths}
\title{Path of a terminal node}
\usage{
treepaths(Tree)
}
\arguments{
\item{Tree}{An object of the class "ranktree"}
}
\value{
A list containing:
\tabular{lll}{
leaves\tab \tab the number of the terminal nodes\cr
size\tab  \tab the sample size within each terminal nodes\cr
paths\tab \tab a list containing all the paths}
}
\description{
Given an object of the class "ranktree", it extracts the paths of all terminal nodes
}
\examples{
\donttest{
data(Irish)
#build the tree with default options
tree <- ranktree(Irish$rankings,Irish$predictors)
#get information about all the paths leading to terminal nodes
paths <- treepaths(tree)
#
#the terminal nodes
paths$leaves
#
#sample size within each terminal node
paths$size
#
#visualize the path of the second leave (terminal node number 8)
paths$paths[[2]]
}


}
\seealso{
\code{\link{ranktree}}, \code{\link{nodepath}}, \code{\link{getsubtree}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
