% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_utils.R
\name{Bootstrap_trans}
\alias{Bootstrap_trans}
\title{Bootstrap using transformation for one group}
\usage{
Bootstrap_trans(N.sim, n1, a, d, p, C, MSrootHatCov, vX, fun)
}
\arguments{
\item{N.sim}{control variable for using sapply}

\item{n1}{a scalar, declaring the sample size for the bootstrap sample}

\item{a}{vector containing the indices which belong to the diagonal of the
covariance matrix}

\item{d}{dimension of the covariance matrix}

\item{p}{dimension of the vectorized matrix}

\item{C}{a hypothesis matrix for calculating the ATS}

\item{MSrootHatCov}{matrix root of the covariance matrix HatCov, to generate
the bootstrap sample}

\item{vX}{the expectation vector for the bootstrap sample}

\item{fun}{transformation function, that should be used.
\code{\link{subdiagonal_mean_ratio_fct}} or
\code{\link{subdiagonal_mean_ratio_cor}}}
}
\value{
a scalar, the value of the ATS
}
\description{
This function generates n1 normal distributed random vectors
with covariance matrix HatCov, which matrix root MSrootHatCov is given and
expectation vector vX. For the generated bootstrap sample the value of the
ATS based on a transformation is calculated
}
\keyword{internal}
