% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_regression_estimator.R
\name{Xij_mat}
\alias{Xij_mat}
\title{Compute \eqn{X_{ij}} Matrix}
\usage{
Xij_mat(X, meanX = mean(X))
}
\arguments{
\item{X}{A vector of values.}

\item{meanX}{The average value of \code{X}. Defaults to \code{mean(X)}.}
}
\value{
A matrix of size \eqn{N \times N}, where \eqn{N} is the length of the vector X.
}
\description{
This helper function computes the matrix of pairwise values, \eqn{X_{ij},} for the kernel regression estimator,
\deqn{X_{ij} = (X_{i} - \bar{X}) (X_{j} - \bar{X}) .}
}
\examples{
X <- c(1, 2, 3, 4)
Xij_mat(X, mean(X))
}
\references{
Hall, P. & Patil, P. (1994). Properties of nonparametric estimators of autocovariance for stationary random fields. Probability Theory and Related Fields 99(3), 399-424. https://doi.org/10.1007/bf01199899

Hall, P., Fisher, N. I., & Hoffmann, B. (1994). On the nonparametric estimation of covariance functions. The Annals of Statistics 22(4), 2115-2134. https://doi.org/10.1214/aos/1176325774
}
