% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.DETs}
\alias{plot.DETs}
\title{DET Curves plot}
\usage{
\method{plot}{DETs}(x, ...)
}
\arguments{
\item{x}{An object of class "DETs".}

\item{...}{Further graphical arguments passed to the \code{plot} function.}
}
\description{
From a 'DETs' object generated with the \code{detc} function, this function plots the different DET curves included in the object. It includes the
Confidence band in case the DETs curves were calculated with a confidence interval.
}
\details{
It accepts plot personalization with graphical parameters (see \code{\link{plot}}, for more details):

-  'xlim': a numeric vector of length 2, giving the x coordinate range of the plot.

-  'ylim': a numeric vector of length 2, giving the y coordinate range of the plot.

-  'col': a vector of colors, specifying the color for each DET curve.

-  'labels_x': a numeric vector indicating the labels of the X axis.

-  'labels_y': a numeric vector indicating the labels of the Y axis.

-  'xlab': a main label for the X axis.

-  'ylab': a main label for the Y axis.

-  'panel.first': a background grid is plotted. It can be used for modifying the background style of the graphic.
}
\examples{
library(DET)
n = 5000
#Predictors with normal distribution
set.seed(1235)
scoreNegative1 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(5321)
scoreNegative2 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(6987)
scoreNegative3 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(11452)
scorePositive1 = rnorm(n, mean = 0.55, sd = 0.125)
set.seed(54321)
scorePositive2 = rnorm(n, mean = 0.65, sd = 0.125)
set.seed(65987)
scorePositive3 = rnorm(n, mean = 0.75, sd = 0.125)
response = as.factor(c(rep(c("target"), times = n), rep(c("nontarget"), times = n)))
predictor1 = c(scoreNegative1, scorePositive1)
predictor2 = c(scoreNegative2, scorePositive2)
predictor3 = c(scoreNegative3, scorePositive3)
predictors = matrix(c(predictor1, predictor2, predictor3), ncol = 3)
colnames(predictors) = c("DET1", "DET2", "DET3")
detCurves = detc(
  response,
  predictors,
  positive = "target",
  names = colnames(predictors)
)
plot(detCurves,
     main = "Example",
     col = c("black", "blue", "red"))
}
