% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DNAmf.R
\name{closed_form_DNA}
\alias{closed_form_DNA}
\title{Closed-form prediction for DNAmf model}
\usage{
closed_form_DNA(
  fit1,
  fit2,
  targett,
  kernel,
  nn,
  tt,
  nlevel,
  x,
  XX = NULL,
  pseudo_yy = NULL
)
}
\arguments{
\item{fit1}{A fitted GP object for \eqn{f_1}.}

\item{fit2}{A fitted GP object for \eqn{f}.}

\item{targett}{A numeric value of target tuning parameter to predict.}

\item{kernel}{A character specifying the kernel type to be used. Choices are \code{"sqex"}(nonseparable squared exponential kernel), \code{"matern1.5"}(nonseparable Matern kernel with \eqn{\nu=1.5}), or \code{"matern2.5"}(nonseparable Matern kernel with \eqn{\nu=2.5}). Default is \code{"sqex"}.}

\item{nn}{A vector specifying the number of design points at each fidelity level.}

\item{tt}{A vector of tuning parameters for each fidelity level.}

\item{nlevel}{The number of fidelity levels \eqn{L}.}

\item{x}{A vector or matrix of new input locations to predict.}

\item{XX}{A list containing a pseudo-complete inputs \code{X_star}(\eqn{\left\{\mathcal{X}^*_l\right\}_{l=1}^{L}}), an original inputs \code{X_list}(\eqn{\left\{\mathcal{X}_l\right\}_{l=1}^{L}}), and a pseudo inputs \code{X_tilde}(\eqn{\left\{\widetilde{\mathcal{X}}_l\right\}_{l=1}^{L}}) for non-nested design.}

\item{pseudo_yy}{A list containing a pseudo-complete outputs \code{y_star}(\eqn{\left\{\mathbf{y}^*_l\right\}_{l=1}^{L}}), an original outputs \code{y_list}(\eqn{\left\{\mathbf{y}_l\right\}_{l=1}^{L}}), and a pseudo outputs \code{y_tilde}(\eqn{\left\{\widetilde{\mathbf{y}}_l\right\}_{l=1}^{L}}) imputed by \code{\link{imputer_DNA}}.}
}
\value{
A list of predictive posterior mean and variance for each level containing:
\itemize{
  \item \code{mu_1}, \code{sig2_1}, ..., \code{mu_L}, \code{sig2_L}: A vector of predictive posterior mean and variance at each level.
  \item \code{mu}: A vector of predictive posterior mean at target tuning parameter.
  \item \code{sig2}: A vector of predictive posterior variance at target tuning parameter.
}
}
\description{
The function computes the closed-form posterior mean and variance for the DNAmf model
both at the fidelity levels used in model fitting and at any user-specified target fidelity level,
using the chosen nonseparable kernel.
}
