% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sql.R
\name{assertTempEmulationSchemaSet}
\alias{assertTempEmulationSchemaSet}
\title{Assert the temp emulation schema is set}
\usage{
assertTempEmulationSchemaSet(
  dbms,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{dbms}{The type of DBMS running on the server. See \code{\link[=connect]{connect()}} or
\code{\link[=createConnectionDetails]{createConnectionDetails()}} for valid values.}

\item{tempEmulationSchema}{The temp emulation schema specified by the user.}
}
\value{
Does not return anything. Throws an error if the DBMS requires temp emulation but the
temp emulation schema is not set.
}
\description{
Asserts the temp emulation schema is set for DBMSs requiring temp table emulation.

If you know your code uses temp tables, it is a good idea to call this function first,
so it can throw an informative error if the user forgot to set the temp emulation schema.
}
