% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_design.R
\name{modify_design}
\alias{modify_design}
\alias{insert_step}
\alias{delete_step}
\alias{replace_step}
\title{Modify a design after the fact}
\usage{
insert_step(design, new_step, before, after)

delete_step(design, step)

replace_step(design, step, new_step)
}
\arguments{
\item{design}{A design object, usually created using the + operator, \code{\link{expand_design}}, or the design library.}

\item{new_step}{The new step; Either a function or a partial call.}

\item{before}{The step before which to add steps.}

\item{after}{The step after which to add steps.}

\item{step}{The quoted label of the step to be deleted or replaced.}
}
\value{
A new design object.
}
\description{
Insert, delete and replace steps in an (already declared) design object.
}
\details{
See \code{\link{modify_design}} for details.
}
\examples{

 my_model <- 
   declare_model(
     N = 100, 
     U = rnorm(N),
     Y_Z_0 = U,
     Y_Z_1 = U + rnorm(N, mean = 2, sd = 2)
   )

 my_assignment <- declare_assignment(Z = complete_ra(N, m = 50))
 my_assignment_2 <- declare_assignment(Z = complete_ra(N, m = 25))

 design <- my_model + my_assignment

 draw_data(design)
 
 design_modified <- replace_step(design, 2, my_assignment_2)
 
 draw_data(design)
 
 \dontrun{
 
 design <- 
   declare_model(
     N = 100,
     U = rnorm(N),
     potential_outcomes(Y ~ 0.20 * Z + U)
   ) + 
     declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) + 
     declare_assignment(Z = complete_ra(N, m = N/2)) + 
     declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
     declare_estimator(Y ~ Z, inquiry = "ATE")
 
 insert_step(design, declare_sampling(S = complete_rs(N, n = 50)),
             after = 1)

 # If you are using a design created by a designer, for example from
 # the DesignLibrary package, you will not have access to the step
 # objects. Instead, you can always use the label of the step.
 
 design <- DesignLibrary::two_arm_designer()
 
 # get the labels for the steps
 names(design)
 
 insert_step(design, 
   declare_sampling(S = complete_rs(N, n = 50)),
   after = "potential_outcomes")
   
 }


design <- 
  declare_model(
    N = 100,
    U = rnorm(N),
    potential_outcomes(Y ~ 0.20 * Z + U)
  ) + 
    declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) + 
    declare_assignment(Z = complete_ra(N, m = N/2)) + 
    declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
    declare_estimator(Y ~ Z, inquiry = "ATE")
delete_step(design, step = 5)


design <- 
  declare_model(
    N = 100,
    U = rnorm(N),
    potential_outcomes(Y ~ 0.20 * Z + U)
  ) + 
    declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) + 
    declare_assignment(Z = complete_ra(N, m = N/2)) + 
    declare_measurement(Y = reveal_outcomes(Y ~ Z)) + 
    declare_estimator(Y ~ Z, inquiry = "ATE")

replace_step(
  design, 
  step = 3, 
  new_step = declare_assignment(Z = simple_ra(N, prob = 0.5)))
}
