context("Utilities")



test_that("pretty printers", {
  expect_output(print(declare_model(sleep)),
                "declare_model\\(sleep\\)")
})


test_that("fallback to lapply", {
  future_lapply <- future_lapply
  environment(future_lapply) <-
    new.env(parent = environment(future_lapply))
  environment(future_lapply)$requireNamespace <- function(...)
    FALSE
  
  expect_identical(future_lapply(LETTERS, identity), as.list(LETTERS))
})


test_that("names from quos", {
  blank_fun <- function(select) {
    reveal_nse_helper(rlang::enquo(select))
  }
  
  expect_equal("bias", blank_fun(select = bias))
  expect_equal(c("bias", "mean"), blank_fun(select = c(bias, mean)))
})


