/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.util.Global;

public class Notifier {
    Vector ton;
    int batchMode = 0;
    NotifyMsg batchLastMsg = null;

    public void addDepend(Dependent dependent) {
        if (this.ton == null) {
            this.ton = new Vector();
        }
        if (!this.ton.contains(dependent)) {
            this.ton.addElement(dependent);
        }
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): add [" + dependent.toString() + "]");
        }
    }

    public void delDepend(Dependent dependent) {
        if (this.ton != null) {
            this.ton.removeElement(dependent);
        }
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): remove [" + dependent.toString() + "]");
        }
    }

    public void NotifyAll(NotifyMsg notifyMsg, Dependent dependent) {
        this.NotifyAll(notifyMsg, dependent, null);
    }

    public void NotifyAll(NotifyMsg notifyMsg, Vector vector) {
        this.NotifyAll(notifyMsg, null, vector);
    }

    public void startCascadedNotifyAll(NotifyMsg notifyMsg) {
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): startCascadedNotifyAll(" + notifyMsg + ")");
        }
        Vector<Notifier> vector = new Vector<Notifier>();
        vector.addElement(this);
        this.NotifyAll(notifyMsg, null, vector);
    }

    public void NotifyAll(NotifyMsg notifyMsg, Dependent dependent, Vector vector) {
        if (Global.DEBUG > 1) {
            System.out.println("Notifier(" + this.toString() + "): send to all message " + notifyMsg);
        }
        if (this.batchMode > 0 || this.ton == null || this.ton.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.ton.elements();
        while (enumeration.hasMoreElements()) {
            Dependent dependent2 = (Dependent)enumeration.nextElement();
            if (dependent2 == dependent) continue;
            if (Global.DEBUG > 0) {
                System.out.println("Notifier(" + this.toString() + "): send " + notifyMsg + " to [" + dependent2.toString() + "]");
            }
            if (vector != null) {
                vector.addElement(this);
                dependent2.Notifying(notifyMsg, this, vector);
                vector.removeElement(this);
                continue;
            }
            dependent2.Notifying(notifyMsg, this, null);
        }
    }

    public void NotifyAll(NotifyMsg notifyMsg) {
        this.NotifyAll(notifyMsg, null, null);
    }

    public void beginBatch() {
        ++this.batchMode;
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): begin batch #" + this.batchMode);
        }
    }

    public void endBatch() {
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): end batch #" + this.batchMode);
        }
        if (this.batchMode > 0) {
            --this.batchMode;
        }
        if (this.batchMode == 0 && this.batchLastMsg != null) {
            this.NotifyAll(this.batchLastMsg);
            this.batchLastMsg = null;
        }
    }
}

