% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kernel}
\alias{kernel}
\alias{kernel_DFWER_singlestep_fast}
\alias{kernel_DFWER_singlestep_crit}
\alias{kernel_DFWER_stepwise_fast}
\alias{kernel_DFWER_stepwise_crit}
\title{Kernel Functions}
\usage{
kernel_DFWER_singlestep_fast(
  pCDFlist,
  pvalues,
  independence = FALSE,
  pCDFcounts = NULL
)

kernel_DFWER_singlestep_crit(
  pCDFlist,
  support,
  sorted_pv,
  alpha = 0.05,
  independence = FALSE,
  pCDFcounts = NULL
)

kernel_DFWER_stepwise_fast(
  pCDFlist,
  sorted_pv,
  independence = FALSE,
  pCDFindices = NULL
)

kernel_DFWER_stepwise_crit(
  pCDFlist,
  support,
  sorted_pv,
  alpha = 0.05,
  independence = FALSE,
  pCDFindices = NULL
)
}
\arguments{
\item{pCDFlist}{list of the supports of the CDFs of the \eqn{p}-values; each list item must be a numeric vector, which is sorted in increasing order and whose last element equals 1.}

\item{pvalues}{numeric vector, sorted in increasing order, that
either must contain the entirety of all observable
values of the p-value supports (when computing
critical constants) or only the sorted raw p-values.}

\item{independence}{single boolean specifying whether the \eqn{p}-values
are independent; if FALSE (the default), the discrete
Bonferroni procedure [d-Bonf] is performed;
otherwise, [d-Ind] is computed.}

\item{pCDFcounts}{integer vector of counts that indicates to how many
p-values each \strong{unique} p-value distributions
belongs.}

\item{support}{numeric vector, sorted in increasing order, that
contains the entirety of all observable values of the
p-value supports.}

\item{sorted_pv}{numeric vector, sorted in increasing order, containing
the raw p-values.}

\item{alpha}{single real number strictly between 0 and 1 indicating
the target FWER level.}

\item{pCDFindices}{list of integer vectors containing the indices that
indicate to which raw \eqn{p}-value in \code{sorted_pv}
each item in \code{pCDFlist} belongs, and must have the
same length as \code{pCDFlist}; if \code{NULL} (the default), it
is assumed that the first item of \code{pCDFlist}
corresponds to the first \eqn{p}-value, the second
item to the second \eqn{p}-value etc. in which case
the lengths of \code{pCDFlist} and \code{sorted_pv} must be
equal.}
}
\value{
For \code{kernel_DFWER_singlestep_fast()} and \code{kernel_DFWER_stepwise_fast()} a
vector of transformed p-values is returned. \code{kernel_DFWER_singlestep_crit}
and \code{kernel_DFWER_stepwise_crit} return a list with critical constants
(\verb{$crit_consts}) and adjusted p-values (\verb{$pval_transf}).
}
\description{
Kernel functions that transform observed p-values or their support according
to a discrete FWER approach. The outputs are used by \code{\link[=discrete_FWER]{discrete_FWER()}}.
\code{kernel_DFWER_fast}, computes the transformed \eqn{p}-values, while
\code{kernel_DFWER_crit} additionally computes and returns the critical
constants. The end user should not use these functions directly, as they are
internal functions and parameters (including their names, order, etc.) may
be changed without notice!
}
\seealso{
\code{\link[=discrete_FWER]{discrete_FWER()}}, \code{\link[=direct_discrete_FWER]{direct_discrete_FWER()}}
}
\keyword{internal}
