% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kuiper2gof.R
\name{Kuiper2gof}
\alias{Kuiper2gof}
\title{Two-Sample Kuiper Test with Bootstrap}
\usage{
Kuiper2gof(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  nboots = 2000,
  keep.boots = FALSE
)
}
\arguments{
\item{x, y}{Numeric vectors of data values for the two samples.}

\item{alternative}{Character string indicating the alternative hypothesis. Must be one of \code{"two.sided"}, \code{"less"}, or \code{"greater"}.}

\item{nboots}{Integer. Number of bootstrap resamples to compute the empirical null distribution (default: 2000).}

\item{keep.boots}{Logical. If \code{TRUE}, returns all bootstrap test statistics.}
}
\value{
An object of class \code{"htest"} containing:
\describe{
  \item{statistic}{The observed Kuiper statistic.}
  \item{p.value}{The p-value computed from the bootstrap distribution.}
  \item{alternative}{The specified alternative hypothesis.}
  \item{method}{A character string describing the test.}
  \item{bootstraps}{(If requested) A numeric vector of bootstrap statistics.}
}
}
\description{
Performs a two-sample Kuiper test using bootstrap resampling to test whether two independent samples come from the same distribution.
}
\details{
The Kuiper test is a nonparametric test similar to the Kolmogorov–Smirnov test,
but sensitive to discrepancies in both location and shape between two distributions.
This implementation uses bootstrap resampling to estimate the p-value.

The \code{two.sided} test uses the sum of maximum positive and negative ECDF differences.
The \code{greater} and \code{less} options use one-sided variations.

If the observed test statistic exceeds all bootstrap values, the p-value is set to \code{1 / (2 * nboots)} to avoid zero.
}
\examples{
set.seed(123)
x <- rnorm(100, 0, 4)
y <- rnorm(100, 2, 4)
Kuiper2gof(x, y)

}
