% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_long_md.R
\name{monitor_long_md}
\alias{monitor_long_md}
\title{Monitor Multivariate Longitudinal Data}
\usage{
monitor_long_md(
  data_array_new,
  time_matrix_new,
  nobs_new,
  pattern,
  side = "both",
  method = "multivariate EWMA",
  parameter = 0.5,
  CL = Inf
)
}
\arguments{
\item{data_array_new}{an array of longitudinal observations. \cr
\code{data_array_new[i,j,k]} is the jth observation of the kth dimension of the ith subject.}

\item{time_matrix_new}{a matrix of observation times. \cr
\code{time_matrix_new[i,j]} is the jth observation time of the ith subject. \cr
\code{data_array_new[i,j,]} is observed at \code{time_matrix[i,j]}.}

\item{nobs_new}{an integer vector for number of observations. \cr
\code{nobs_new[i]} is the number of observations for the ith subject.}

\item{pattern}{the estimated regular longitudinal pattern}

\item{side}{a string \cr
If \code{side="upward"}, control charts aim to detect upward shifts. \cr
If \code{side="downward"}, control charts aim to detect downward shifts. \cr
If \code{side="both"}, control charts aim to detect shifts in both sides.}

\item{method}{a string \cr
If \code{method="simultaneous CUSUM"}, 
apply simultaneous CUSUM charts. (See SIMUL in You et al, 2020.) \cr
If \code{method="simultaneous EWMA"},
apply simultaneous EWMA charts. (See SIMUL in You et al, 2020.) \cr
If \code{method="multivariate CUSUM"},
apply multivariate CUSUM charts. \cr
If \code{method="multivariate EWMA"},
apply multivariate EWMA charts. (See Qiu and Xiang, 2015 or QX-1S/QS-2S in You et al, 2020.) \cr
If \code{method="decorrelation CUSUM"},
apply decorrelation CUSUM charts. (See Li and Qiu, 2017 or LQ-1S/LQ-2S in You et al, 2020) \cr
If \code{method="decorrelation EWMA"},
apply decorrelation EWMA charts. (See Li and Qiu, 2017 or LQ-1S/LQ-2S in You et al, 2020) \cr
If \code{method="nonparametric CUSUM"} \cr
If \code{method="nonparametric EWMA"} \cr}

\item{parameter}{a numeric value. \cr
\code{parameter} is the allowance constant if \code{method} is a CUSUM chart. \cr
\code{parameter} is the weighting parameter if \code{method} is an EWMA chart.}

\item{CL}{a numeric value \cr
\code{CL} is the control limit. 
A signal will be given if charting statistics are larger than the control limit. 
(Note: in this package, signs of charting statistics may be reversed such that 
larger values of charting statistics indicate worse performance of processes.)
After the signal is given, the algorithm stops calculating the charting statistics for the remaining observation times.
The default value of control limit is infinity, which means we will calculate the charting statistics for all observation times.}
}
\value{
a list that stores the result.\cr
\item{$chart}{a numeric matrix, \code{$chart[i,j]} is the jth charting statistic of the ith subject calculated at time \code{time_matrix_new[i,j]}.}\cr
\item{$SSijk}{a numeric array, the multivariate statistics used in the calculation of control charts.
\code{$SSijk[i,j,]} is the jth multivariate statistic for the ith subject.}
\item{$standardized_values}{a numeric array.
\code{$standardized_values[i,j,]} is the jth standardized vector for the ith subject.}
}
\description{
Monitor Multivariate Longitudinal Data
}
\examples{
data("data_example_long_md")

result_pattern<-estimate_pattern_long_md(
  data_array=data_example_long_md$data_array_IC,
  time_matrix=data_example_long_md$time_matrix_IC,
  nobs=data_example_long_md$nobs_IC,
  design_interval=data_example_long_md$design_interval,
  n_time_units=data_example_long_md$n_time_units,
  estimation_method="meanvar",
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_md(
data_array_new=data_example_long_md$data_array_OC,
time_matrix_new=data_example_long_md$time_matrix_OC,
nobs_new=data_example_long_md$nobs_OC,
pattern=result_pattern,
side="both",
method="multivariate EWMA",
parameter=0.5)

result_ATS<-calculate_ATS(
  chart_matrix=result_monitoring$chart_matrix,
  time_matrix=data_example_long_md$time_matrix_OC,
  nobs=data_example_long_md$nobs_OC,
  starttime=rep(0,nrow(data_example_long_md$time_matrix_OC)),
  endtime=rep(1,nrow(data_example_long_md$time_matrix_OC)),
  design_interval=data_example_long_md$design_interval,
  n_time_units=data_example_long_md$n_time_units,
  CL=16.0)
}
\references{
Qiu, P. and Xiang, D. (2015). Surveillance of cardiovascular diseases using a multivariate dynamic screening system. Statistics in Medicine, 34:2204-2221. \cr
Li, J. and Qiu, P. (2017). Construction of an efficient multivariate dynamic screening system. Quality and Reliability Engineering International, 33(8):1969-1981. \cr
You, L., Qiu, A., Huang, B., and Qiu, P. (2020). Early detection of severe juvenile idiopathic arthritis by sequential monitoring of patients' health-related quality of life scores. Biometrical Journal, 62(5).
}
