% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_inner.R
\name{\%*\%,Dyadic,Dyadic-method}
\alias{\%*\%,Dyadic,Dyadic-method}
\title{Matrix multiplication of dyadic objects}
\usage{
\S4method{\%*\%}{Dyadic,Dyadic}(x, y)
}
\arguments{
\item{x}{\code{Dyadic}-object;}

\item{y}{\code{Dyadic}-object;}
}
\value{
Either a \code{Dyadic}-object or a regular matrix depending on the structure type
of the input objects. The matrix outcome of multiplication is also
reported as a message in the command line.
}
\description{
The standard matrix multiplication of two \code{Dyadic}-objects.
}
\details{
Both orders of multiplication are implemented: \code{(scalar * dyadic)} and \code{(dyadic * scalar)}.
}
\section{References}{

Kos, M., Podgórski, K., & Wu, H. (2025). Dyadic Factorization and Efficient Inversion of Sparse Positive Definite Matrices. arXiv. https://arxiv.org/abs/2505.08144
}

\examples{
#--------------------------------------------------#
#------- Multiplication of dyadic matrices --------#
#--------------------------------------------------#

N <- 4
k <- 3

# Construct four types of dyadic matrices with made of 1's
V <- construct(N, k, type = "vert") # vertical
H <- construct(N, k, type = "horiz") # horizontal
S <- construct(N, k, type = "symm") # symmetric
AS <- construct(N, k, type = "asymm") # asymmetric

# Convert the dyadic matrices to matrix format
mat_V <- as.matrix(V)
mat_H <- as.matrix(H)
mat_S <- as.matrix(S)
mat_AS <- as.matrix(AS)

# Multiplication of dyadic matrices
VV <- V \%*\% V # vertical * vertical = vertical
HH <- H \%*\% H # horizontal * horizontal = horizontal
HS <- H \%*\% S # horizontal * symmetric = asymmetric
HV <- H \%*\% V # horizontal * vertical = asymmetric
ASV <- AS \%*\% V # asymmetric * vertical = asymmetric

VH <- V \%*\% H # vertical * horizontal = non-dyadic
VS <- V \%*\% S # vertical * symmetric = non-dyadic
VAS <- V \%*\% AS # vertical * asymmetric = non-dyadic

SS <- S \%*\% S # symmetric * symmetric = non-dyadic
ASAS <- AS \%*\% AS # asymmetric * asymmetric = non-dyadic
ASH <- AS \%*\% H # asymmetric * horizontal = non-dyadic

dim(ASAS) # regular matrix
}
\seealso{
\code{\link{Dyadic-class}} for the definition of the \code{Dyadic}-class;
\code{\link{dyadFac}} for the dyadic decomposition of dyadic matrices;
}
