% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edc_unify_subjid.R
\name{edc_unify_subjid}
\alias{edc_unify_subjid}
\alias{harmonize_subjid}
\title{Harmonize the subject ID of the database}
\usage{
edc_unify_subjid(
  database,
  preprocess = NULL,
  mode = c("factor", "numeric"),
  col_subjid = NULL
)
}
\arguments{
\item{database}{an \link{edc_database} object, from \code{\link[=read_trialmaster]{read_trialmaster()}} or other EDCimport reading functions.}

\item{preprocess}{an optional function to modify the subject ID column (at the character level). Default behavior is only to remove trailing zeros if numeric.}

\item{mode}{the output type of the subject ID columns}

\item{col_subjid}{names of the subject ID columns (as character)}
}
\value{
database, with subject id modified
}
\description{
Turns the subject ID columns of all datasets into a factor containing levels for all
the subjects of the database. Avoid problems when joining tables, and some checks can
be performed on the levels. See \code{vignette("postprocessing")} for a real-life case.
}
\examples{

db = edc_example()
db$enrol$subjid \%>\% head()  #double vector

db2 = edc_unify_subjid(db)
db2$enrol$subjid \%>\% head() #factor with 50 levels

db3 = edc_unify_subjid(db, preprocess=function(x) paste0("#", x))
db3$enrol$subjid \%>\% head()

#use numeric mode to get a numeric output
db4 = edc_unify_subjid(db, preprocess=function(x) as.numeric(x)+1, mode="numeric")
db4$enrol$subjid \%>\% head()
}
