\name{happy_cat}
\alias{happy_cat}
\title{Happy Cat Function for Benchmarking Optimization Algorithms}

\usage{
happy_cat(x)
}

\arguments{
\item{x}{
  A numeric vector representing the input variables. The length of \code{x} determines the dimensionality of the problem.
  }
}

\value{
Returns a numeric value representing the evaluation of the Happy Cat function at the input vector \code{x}.
}

\description{
The Happy Cat function is a multimodal test function commonly used to assess the performance of optimization algorithms. It features a complex landscape that combines quadratic terms and interactions between variables, making it suitable for testing optimization methods in high-dimensional spaces.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
happy_cat(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
happy_cat(x)

# Contour Plot: Visualizing the Happy Cat Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) happy_cat(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour plot of Happy Cat Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = happy_cat, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) happy_cat(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Happy Cat Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Beyer, H.-G., & Finck, S. (2012). HappyCat – A Simple Function Class Where Well-Known Direct Search Algorithms Do Fail. In Parallel Problem Solving from Nature (pp. 367–376). Springer.
}
