% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFAscreet.R
\name{EFAscreet}
\alias{EFAscreet}
\title{Scree Plot}
\usage{
EFAscreet(
  response,
  fa = "pc",
  nfact = 1,
  cor.type = "pearson",
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses of \code{N} individuals
to \code{I} items.}

\item{fa}{A string that determines the method used to obtain eigenvalues. If \code{'pc'}, it represents
Principal Component Analysis (PCA); if \code{'fa'}, it represents Principal Axis Factoring (a widely
used Factor Analysis method; @seealso \code{\link[EFAfactors]{factor.analysis}};
Auerswald & Moshagen, 2019). (Default = 'pc')}

\item{nfact}{A numeric value that specifies the number of factors to extract, only effective when \code{fa = 'fa'}. (Default = 1)}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or
\code{"spearman"}. @seealso \code{\link[stats]{cor}}.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"}, \code{"na.or.complete"},
or \code{"pairwise.complete.obs"} (default). @seealso \code{\link[stats]{cor}}.}
}
\value{
An object of class \code{EFAscreet} is a \code{list} containing the following components:
\item{eigen.value}{A vector containing the empirical eigenvalues}
}
\description{
This function generates a scree plot to display the eigenvalues of the correlation matrix
computed from the given response data. The scree plot helps in determining the number of
factors to retain in exploratory factor analysis by examining the point at which the
eigenvalues start to level off, indicating less variance explained by additional factors.
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1


## Run EFAscreet function with default parameters.
\donttest{
EFAscreet.obj <- EFAscreet(response)

plot(EFAscreet.obj)

}


}
\seealso{
\code{\link[EFAfactors]{plot.EFAscreet}}
}
