% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kalman_functions.R
\name{plotWRTDSKalman}
\alias{plotWRTDSKalman}
\title{plotWRTDSKalman}
\usage{
plotWRTDSKalman(eList, sideBySide = FALSE, fluxUnit = 9,
  usgsStyle = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. This
eList must be run through \code{WRTDSKalman}.}

\item{sideBySide}{logical. If \code{TRUE}, the two plots will be plotted
side by side, otherwise, one by one vertically.}

\item{fluxUnit}{number representing entry in pre-defined fluxUnit class array. \code{\link{printFluxUnitCheatSheet}}}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS compliance. It will only change automatically
generated labels}
}
\description{
Two plots to check the flux estimates using the WRTDS_K vs classic WRTDS.
The first is annual flux over time, where the two fluxes are shown in different colors.
The second is WRTDS vs WRTDSKalman flux estimates. The graphs can be output
either on top of each other, or side by side using the \code{sideBySide} argument.
}
\examples{

eList <- Choptank_eList
eList <- WRTDSKalman(eList, niter = 10)
plotWRTDSKalman(eList)

plotWRTDSKalman(eList, sideBySide = TRUE)

}
